﻿//////////////////////////////////////////////
// RenderContextDescriptor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Texture ;
}

namespace nkWinUi
{
	class Window ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RenderContextDescriptor final
	{
		public :

			// Attributes
			// Size in pixels
			unsigned int _width ;
			unsigned int _height ;

			// Pointer over window (non offscreen) or texture (offscreen) if applicable
			union
			{
				nkWinUi::Window* _window ;
				Texture* _texture ;
			} ;

			// If this is an offscreen context or not
			bool _offscreenContext ;
			// If it will use vsync or not (onscreen only)
			bool _vsync ;

		public :

			// Functions
			// Constructor, destructor
			RenderContextDescriptor () noexcept ;
			RenderContextDescriptor (nkWinUi::Window* window) noexcept ;
			RenderContextDescriptor (nkGraphics::Texture* texture) noexcept ;
			RenderContextDescriptor (unsigned int width, unsigned int height, bool forOffscreen, bool vsync = false) noexcept ;
	} ;
}